---
title: Tutorial · Cloudflare Style Guide
description: A tutorial is a practical lesson that takes you from a clear
  starting to ending point.
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/tutorial/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/tutorial/index.md
---

A tutorial is a practical lesson that takes you from a clear starting to ending point.

The goal is to connect products to real-world scenarios to meet a user’s goal.

Note

If you are unsure about when to categorize something as a how-to or tutorial, remember:

Tutorials are typically longer form and contain multiple steps, usually involving multiple products, and help users connect products to real-world scenarios.

A how-to helps a user complete a singular task within a single product.

## Guidelines

**A tutorial is:**

* User-focused
* Aligned to a user's goal or job-to-be-done
* Descriptive and guiding

**A tutorial can:**

* Describe how to integrate with a third party
* Be delivered in the Cloudflare dashboard
* Describe how to set up multiple products to complete a single job-to-be-done

**A tutorial is not:**

* Product configuration information, how-to (or any of the other content types)
* How to complete a task in the UI or API
* A dumping ground for screenshots
* Content with no end goal or job-to-be-done

### Tone

Guiding, straightforward, educational, authoritative

### content\_type

```yaml
pcx_content_type: tutorial
```

For more details, refer to [`pcx_content_type`](https://developers.cloudflare.com/style-guide/frontmatter/custom-properties/#pcx_content_type).

### Components

#### Most used

* [`GitHubCode`](https://developers.cloudflare.com/style-guide/components/github-code/)
* [`LastReviewed`](https://developers.cloudflare.com/style-guide/components/last-reviewed/)
* [`ListTutorials`](https://developers.cloudflare.com/style-guide/components/list-tutorials/)

#### Required

[**Title**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/titles/): Short verb phrase in second-person imperative.

**Context**: An introductory paragraph on the user's goal or job-to-be-done and how they will accomplish that in the tutorial. Consider including the intended audience for the tutorial. Refer to [Context](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/context/) for more information.

**Consider the user story framing**: "As a `___`, I want to `___` so I can `___`."

[**Steps**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/steps-tasks-procedures/): Numbered steps that complete a task.

#### Optional

[**Notes/warnings**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/notes-tips-warnings/)

[**Examples**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/examples/)

**Screenshots**

[**Links**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/links/)

**Boundaries**

## Examples

[Workers Tutorials](https://developers.cloudflare.com/workers/tutorials)
