---
title: Update TLS versions · Cloudflare Learning Paths
description: In some circumstances - specifically when an application allows
  client-initiated SSL/TLS renegotiation - previous versions of SSL/TLS can be
  more vulnerable to DDoS attacks.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/prevent-ddos-attacks/baseline/tls-versions/
  md: https://developers.cloudflare.com/learning-paths/prevent-ddos-attacks/baseline/tls-versions/index.md
---

In some circumstances - specifically when an application allows client-initiated SSL/TLS renegotiation - previous versions of SSL/TLS can be more vulnerable to DDoS attacks.

When you use an SSL/TLS certificate issued by Cloudflare[1](#user-content-fn-1), you can reduce the impact of this vulnerability by:

* Updating the [Minimum TLS Version](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/minimum-tls/) accepted by your application.
* Allowing [TLS 1.3](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/tls-13/).

## Additional resources

For more details on this vulnerability, refer to [Secure Server- and Client-Initiated SSL Renegotiation](https://crashtest-security.com/secure-client-initiated-ssl-renegotiation/).

## Footnotes

1. Meaning either [Universal](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/) or [Advanced](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/) certificates. [↩](#user-content-fnref-1)
