---
title: User managed quarantine and administrative quarantine - Office 365 ·
  Cloudflare Email security (formerly Area 1) docs
description: In this tutorial, you will learn to deliver SPAM and SPOOF messages
  to the user managed quarantine, and MALICIOUS messages to the administrative
  quarantine (this requires an administrator to release the emails).
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/email-security/deployment/inline/setup/office-365-area1-mx/use-cases/four-user-quarantine-admin-quarantine/
  md: https://developers.cloudflare.com/email-security/deployment/inline/setup/office-365-area1-mx/use-cases/four-user-quarantine-admin-quarantine/index.md
---

In this tutorial, you will learn to deliver `SPAM` and `SPOOF` messages to the user managed quarantine, and `MALICIOUS` messages to the administrative quarantine (this requires an administrator to release the emails).

## Configure domains

You first need to configure the domains you are onboarding on the Email Security (formerly Area 1) dashboard. To configure your domains:

1. Log in to the [Email Security dashboard](https://horizon.area1security.com/).

2. Go to **Settings** (the gear icon).

3. Go to **Email configuration** > **Domains & Routing** > **Domains**.

4. Make sure each domain you are onboarding has been added.

5. For each domain you are configuring, select **...** > **Edit**, and set the following options:

   * **Domain** - `<YOUR_DOMAIN>`.
   * **Configured as** - `MX Records`.
   * **Forwarding to** - This should match the expected MX record for each domain in your [Office 365 account](https://admin.microsoft.com/#/Domains/).
   * **IP Restrictions** - Leave this field empty.
   * **Outbound TLS** - `Forward all messages over TLS`.
   * **Quarantine Policy** - Do not check any dispositions.

## Create quarantine policies

To create quarantine policies:

1. Open the [Microsoft 365 Defender console](https://security.microsoft.com/).

2. Go to **Email & collaboration** > **Policies & rules**.

3. Select **Threat policies**.

4. Under **Rules**, select **Quarantine policies**.

5. Select **Add custom policy**.

6. Set the **Policy name** to `UserNotifyUserRelease`.

7. Select **Next**.

8. In **Recipient message access**, select **Set specific access (Advanced)**, and then:

   * In **Select release action preference**, choose *Allow recipients to release a message from quarantine*.
   * In **Select additional actions recipients can take on quarantined messages**, select the **Delete** and **Preview** checkboxes.

   ![Configure the Recipient message access as stated in the step above](https://developers.cloudflare.com/_astro/step8-allow-message-release.C-1nPIVh_Z1GhJps.webp)

9. Select **Next**.

10. In **Quarantine notification**, select **Enable**.

11. Select **Next**.

12. Review your settings and select **Submit**.

13. Select **Done**.

14. Select **Add custom policy**.

15. Set the **Policy name** to `UserNotifyAdminRelease`.

16. Select **Next**.

17. In **Recipient message access**, select **Set specific access (Advanced)**, and then:

    * In **Select release action preference**, from the drop-down menu, choose *Allow recipients to request a message to be released from quarantine*.
    * In **Select additional actions recipients can take on quarantined messages**, select the **Delete** and **Preview** checkboxes.

    ![Configure the Recipient message access as stated in the step above](https://developers.cloudflare.com/_astro/step8-request-message-release.DVEdlfTt_10mYfB.webp)

18. Select **Next**.

19. In **Quarantine notification**, select **Enable**.

20. Select **Next**.

21. Review your settings and select **Submit**.

22. Select **Done**.

## Configure quarantine notifications

To configure quarantine notifications:

1. Open the [Microsoft 365 Defender console](https://security.microsoft.com/).

2. Go to **Email & collaboration** > **Policies & rules**.

3. Select **Threat policies**.

4. Under **Rules**, select **Quarantine policies**.

5. Select **Global settings**.

6. Scroll to the bottom and set the desired frequency in **Send end-user spam notifications every (days)**. This value can only be incremented in days.

   ![Configure the desired spam notification frequency](https://developers.cloudflare.com/_astro/step6-spam-notifications.5FY4mM54_Z2e4aOK.webp)

7. Select **Save**.

## Configure anti-spam policies

To configure anti-spam policies:

1. Open the [Microsoft 365 Defender console](https://security.microsoft.com/)

2. Go to **Email & collaboration** > **Policies & rules**.

3. Select **Threat policies**.

4. Under **Policies**, select **Anti-spam**.

5. Select the **Anti-spam inbound policy (Default)** text (not the checkbox).

6. In the **Actions** section, scroll down and select **Edit actions**.

   ![Go to Actions and find Edit actions](https://developers.cloudflare.com/_astro/step6-edit-actions.T4_p91g__FX92f.webp)

7. Set the following conditions and actions (you might need to scroll up or down to find them):

   * **Spam**: *Quarantine message*.
     * **Select quarantine policy**: *UserNotifyUserRelease*.
   * **High confidence spam**: *Quarantine message*.
     * **Select quarantine policy**: *UserNotifyAdminRelease*.
   * **Phishing**: *Quarantine message*.
     * **Select quarantine policy**: *UserNotifyAdminRelease*.
   * **High confidence phishing**: *Quarantine message*.
     * **Select quarantine policy**: *UserNotifyAdminRelease*.
   * **Retain spam in quarantine for this many days**: Default is 15 days. Email security recommends 15-30 days.

   ![Select the spam actions in the above step](https://developers.cloudflare.com/_astro/step7-quarantine-message-case4.Bz4nU_HV_Z2qGHaq.webp)

8. Select **Save**.

## Create transport rules

To create the transport rules that will send emails with certain dispositions to Email Security:

1. Open the new [Exchange admin center](https://admin.exchange.microsoft.com/#/homepage).

2. Go to **Mail flow** > **Rules**.

3. Select **Add a Rule** > **Create a new rule**.

4. Set the following rule conditions:

   * **Name**: *\`Email security User Quarantine Message\`*.

   * **Apply this rule if**: *The message headers* > *includes any of these words*.

     * **Enter text**: `X-Area1Security-Disposition` > **Save**.
     * **Enter words**: `` `UCE`, `SPOOF` `` > **Add** > **Save**.

   * **Apply this rule if**: Select **+** to add a second condition.

   * **And**: *The sender* > *IP address is in any of these ranges or exactly matches* > enter the egress IPs in the [Egress IPs page](https://developers.cloudflare.com/email-security/deployment/inline/reference/egress-ips/).

   * **Do the following** - *\_Modify the message properties\_ > \_Set the Spam Confidence Level (SCL)\_ > \_5\_*.

1) Select **Next**.

2) You can use the default values on this screen. Select **Next**.

3) Review your settings and select **Finish** > **Done**.

4) Select the rule \`Email security User Quarantine Message\` you have just created, and **Enable**.

5) Select **Add a Rule** > **Create a new rule**.

6) Set the following rule conditions:

   * **Name**: *\`Email security User Quarantine Message Admin Release\`*.

   * **Apply this rule if**: *The message headers* > *includes any of these words*.

     * **Enter text**: `X-Area1Security-Disposition` > **Save**.
     * **Enter words**: *\`MALICIOUS\`* > **Add** > **Save**.

   * **Apply this rule if**: Select **+** to add a second condition.

   * **And**: *The sender* > *IP address is in any of these ranges or exactly matches* > enter the egress IPs in the [Egress IPs page](https://developers.cloudflare.com/email-security/deployment/inline/reference/egress-ips/).

   * **Do the following**: *\_Modify the message properties\_ > \_Set the Spam Confidence Level (SCL)\_ > \_9\_*.

1. Select **Next**.

2. You can use the default values on this screen. Select **Next**.

3. Review your settings and select **Finish** > **Done**.

4. Select the rule *\`Email security User Quarantine Message Admin Release\`* you have just created, and select **Enable**.
