---
title: Pipelines now supports SQL transformations and Apache Iceberg · Changelog
description: Transform streaming data with SQL and write to Apache Iceberg tables in R2
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-09-25-pipelines-sql/
  md: https://developers.cloudflare.com/changelog/2025-09-25-pipelines-sql/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Pipelines now supports SQL transformations and Apache Iceberg

Sep 25, 2025

[Pipelines](https://developers.cloudflare.com/pipelines/)

Today, we're launching the new [Cloudflare Pipelines](https://developers.cloudflare.com/pipelines/): a streaming data platform that ingests events, transforms them with [SQL](https://developers.cloudflare.com/pipelines/sql-reference/select-statements/), and writes to [R2](https://developers.cloudflare.com/r2/) as [Apache Iceberg](https://iceberg.apache.org/) tables or Parquet files.

Pipelines can receive events via [HTTP endpoints](https://developers.cloudflare.com/pipelines/streams/writing-to-streams/#send-via-http) or [Worker bindings](https://developers.cloudflare.com/pipelines/streams/writing-to-streams/#send-via-workers), transform them with SQL, and deliver to R2 with exactly-once guarantees. This makes it easy to build analytics-ready warehouses for server logs, mobile application events, IoT telemetry, or clickstream data without managing streaming infrastructure.

For example, here's a pipeline that ingests clickstream events and filters out bot traffic while extracting domain information:

```sql
INSERT into events_table
SELECT
  user_id,
  lower(event) AS event_type,
  to_timestamp_micros(ts_us) AS event_time,
  regexp_match(url, '^https?://([^/]+)')[1]  AS domain,
  url,
  referrer,
  user_agent
FROM events_json
WHERE event = 'page_view'
  AND NOT regexp_like(user_agent, '(?i)bot|spider');
```

Get started by creating a pipeline in the dashboard or running a single command in [Wrangler](https://developers.cloudflare.com/workers/wrangler/):

```bash
npx wrangler pipelines setup
```

Check out our [getting started guide](https://developers.cloudflare.com/pipelines/getting-started/) to learn how to create a pipeline that delivers events to an [Iceberg table](https://developers.cloudflare.com/r2/data-catalog/) you can query with R2 SQL. Read more about today's announcement in our [blog post](https://blog.cloudflare.com/cloudflare-data-platform).
