---
title: Improved memory efficiency for WebAssembly Workers · Changelog
description: With the introduction of FinalizationRegistry in Workers Runtime,
  toolchains like Emscripten and wasm-bindgen can automatically reclaim unused
  WebAssembly heap and reduce memory leaks.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-05-08-finalization-registry/
  md: https://developers.cloudflare.com/changelog/2025-05-08-finalization-registry/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Improved memory efficiency for WebAssembly Workers

May 08, 2025

[Workers](https://developers.cloudflare.com/workers/)

[FinalizationRegistry](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/FinalizationRegistry) is now available in Workers. You can opt-in using the [`enable_weak_ref`](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#enable-finalizationregistry-and-weakref) compatibility flag.

This can reduce memory leaks when using WebAssembly-based Workers, which includes [Python Workers](https://developers.cloudflare.com/workers/languages/python/) and [Rust Workers](https://developers.cloudflare.com/workers/languages/rust/). The FinalizationRegistry works by enabling toolchains such as [Emscripten](https://emscripten.org/) and [wasm-bindgen](https://rustwasm.github.io/wasm-bindgen/) to automatically free WebAssembly heap allocations. If you are using WASM and seeing Exceeded Memory errors and cannot determine a cause using [memory profiling](https://developers.cloudflare.com/workers/observability/dev-tools/memory-usage/), you may want to enable the FinalizationRegistry.

For more information refer to the [`enable_weak_ref`](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#enable-finalizationregistry-and-weakref) compatibility flag documentation.
